// OperacjeNaPlikachIFDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OperacjeNaPlikachIF.h"
#include "OperacjeNaPlikachIFDlg.h"
#include <shobjidl.h>
#include <shlobj.h>
#include <shlwapi.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// COperacjeNaPlikachIFDlg dialog


COperacjeNaPlikachIFDlg::COperacjeNaPlikachIFDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COperacjeNaPlikachIFDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COperacjeNaPlikachIFDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(COperacjeNaPlikachIFDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &COperacjeNaPlikachIFDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &COperacjeNaPlikachIFDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &COperacjeNaPlikachIFDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &COperacjeNaPlikachIFDlg::OnBnClickedButton4)
END_MESSAGE_MAP()


// COperacjeNaPlikachIFDlg message handlers

BOOL COperacjeNaPlikachIFDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COperacjeNaPlikachIFDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COperacjeNaPlikachIFDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

HRESULT COperacjeNaPlikachIFDlg::OperacjaNaPlikuIF(LPCTSTR szZrodlo, LPCTSTR szCel, DWORD operacja, DWORD opcje)
{
	if(!PathFileExists(szZrodlo)) // Czy plik rdowy istnieje?
	{
		AfxMessageBox(L"Nie odnaleziono pliku");
		return E_POINTER;
	}

	CT2W wszZrodlo(szZrodlo);
	CT2W wszCel(szCel);
	CString wszNowaNazwa = PathFindFileNameW(wszCel);
	PathRemoveFileSpec(wszCel);
	
	// Tworzenie nowej instancji interfejsu IFileOperation
	IFileOperation *iFo;
	HRESULT hr = CoCreateInstance(CLSID_FileOperation, 
                              NULL, 
                              CLSCTX_LOCAL_SERVER, 
                              IID_PPV_ARGS(&iFo));
	if(!SUCCEEDED(hr))
		return hr;

	iFo->SetOperationFlags(opcje);
	
	// Tworzenie obiektow IShellItem
	IShellItem *psiCel = NULL, *psiZrodlo = NULL;
	SHCreateItemFromParsingName(wszZrodlo, NULL, IID_PPV_ARGS(&psiZrodlo));
	
	if(wszCel != NULL)
		SHCreateItemFromParsingName(wszCel, NULL, IID_PPV_ARGS(&psiCel));
	
	// Kopiowanie, przenoszenie, czy usuwanie?
	switch(operacja)
	{
		case FO_COPY: iFo->CopyItem(psiZrodlo, psiCel, wszNowaNazwa, NULL); break;
		case FO_MOVE: iFo->MoveItem(psiZrodlo, psiCel, wszNowaNazwa, NULL); break;
		case FO_DELETE: iFo->DeleteItem(psiZrodlo, NULL); break;
	}

	// Potwierdzenie wykonania operacji
	hr = iFo->PerformOperations();
	if(!SUCCEEDED(hr))
		return hr;

	psiZrodlo->Release();
	if(psiCel != NULL)
		psiCel->Release();
	
	// Zwolnienie interfejsu
	iFo->Release();

	return hr;
}

HRESULT COperacjeNaPlikachIFDlg::KopiowaniePliku(LPCTSTR szZrodlo, LPCTSTR szCel)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);
	
	return OperacjaNaPlikuIF(lpBuffer, szCel, FO_COPY, 0);
}

HRESULT COperacjeNaPlikachIFDlg::PrzenoszeniePliku(LPCTSTR szZrodlo, LPCTSTR szCel)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);
	
	return OperacjaNaPlikuIF(lpBuffer, szCel, FO_MOVE, 0);
}

HRESULT COperacjeNaPlikachIFDlg::UsuwaniePliku(LPCTSTR szZrodlo)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);
	
	return OperacjaNaPlikuIF(lpBuffer, NULL, FO_DELETE, 0);
}

HRESULT COperacjeNaPlikachIFDlg::UsuwaniePlikuBezPotwierdzenia(LPCTSTR szZrodlo)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);
	
	return OperacjaNaPlikuIF(lpBuffer, NULL, FO_DELETE, FOF_NOCONFIRMATION);
}

HRESULT COperacjeNaPlikachIFDlg::UsuwaniePlikuDoKosza(LPCTSTR szZrodlo)
{
	TCHAR lpBuffer[MAX_PATH] = {0};
	GetFullPathName(szZrodlo, MAX_PATH, lpBuffer, NULL);
	
	return OperacjaNaPlikuIF(lpBuffer, NULL, FO_DELETE, FOF_ALLOWUNDO);
}

void COperacjeNaPlikachIFDlg::TworzPlikTestowy(LPCTSTR sciezkaPliku)
{
	HANDLE hFile = CreateFileW(sciezkaPliku, GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
	CloseHandle(hFile);
}

HRESULT COperacjeNaPlikachIFDlg::KopiowanieKatalogu(LPCTSTR szZrodlo, LPCTSTR szCel)
{
	return OperacjaNaPlikuIF(lpBuffer, szCel, FO_COPY, FOF_NOCONFIRMMKDIR);
}

HRESULT COperacjeNaPlikachIFDlg::PrzenoszenieKatalogu(LPCTSTR szZrodlo, LPCTSTR szCel)
{
	HRESULT wynik = OperacjaNaPlikuIF(szZrodlo, szCel, FO_MOVE, FOF_NOCONFIRMMKDIR);
	RemoveDirectory(szZrodlo);
	return wynik;
}

HRESULT COperacjeNaPlikachIFDlg::UsuwanieKatalogu(LPCTSTR szZrodlo)
{	
	return UsuwaniePliku(lpBuffer);
}

HRESULT COperacjeNaPlikachIFDlg::UsuwanieKataloguDoKosza(LPCTSTR szZrodlo)
{
	return UsuwaniePlikuDoKosza(lpBuffer);
}

void COperacjeNaPlikachIFDlg::OnBnClickedButton1()
{
	CString sciezkaPliku = L"d:\\test.txt";
	HANDLE hFile = CreateFileW(sciezkaPliku, GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
	CloseHandle(hFile);
	TworzPlikTestowy(sciezkaPliku);
	KopiowaniePliku(sciezkaPliku, L"d:\\test kopia.txt");
	PrzenoszeniePliku(L"d:\\test kopia.txt", L"d:\\kopia xml.xml");
	UsuwaniePliku(L"d:\\kopia xml.xml");
}

void COperacjeNaPlikachIFDlg::OnBnClickedButton2()
{
	CString sciezkaPliku = L"d:\\test.txt";
	HANDLE hFile = CreateFileW(sciezkaPliku, GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
	CloseHandle(hFile);
	UsuwaniePlikuBezPotwierdzenia(sciezkaPliku);
}

void COperacjeNaPlikachIFDlg::OnBnClickedButton3()
{
	CString sciezkaPliku = L"d:\\test.txt";
	HANDLE hFile = CreateFileW(sciezkaPliku, GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
	CloseHandle(hFile);
	UsuwaniePlikuDoKosza(sciezkaPliku);	
}


void COperacjeNaPlikachIFDlg::OnBnClickedButton4()
{
	CreateDirectory(L"d:\\test2", NULL);
	CreateDirectory(L"d:\\test3", NULL);
	KopiowanieKatalogu(L"d:\\test2", L"d:\\test4");
	UsuwanieKatalogu(L"d:\\test2");
	UsuwanieKataloguDoKosza(L"d:\\test3");
	PrzenoszenieKatalogu(L"d:\\test4", L"d:\\test8");
}
